﻿//////////////////////////////////////////////
// RelativeLayout.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "../Enums/RelativePosition.h"

#include "Layout.h"

// nkMaths
#include <NilkinsMaths/Geometry/Rectangle.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <vector>

/// Internals --------------------------------

namespace nkWinUi
{
	struct RelativeLayoutEntryInfo
	{
		Component* _component = nullptr ;
		RELATIVE_POSITION _position ;
		nkMaths::Rectangle  _area ;

		RelativeLayoutEntryInfo* _relativeTo = nullptr ;
		std::vector<RelativeLayoutEntryInfo*> _children ;
	} ;
}

/// Class ------------------------------------
	
namespace nkWinUi
{
	class DLL_WINUI_EXPORT RelativeLayout final : public Layout
	{		
		public :
		
			// Constructeur, destructeur
			RelativeLayout (System* system) noexcept ;
			RelativeLayout (const RelativeLayout&) = delete ;
			virtual ~RelativeLayout () ;

			// Getters
			Component* getComponentAt (unsigned int index) const ;

			// Setters
			virtual void setParentComponent (Component* parent) override ;

			// Components
			void addComponent (Component* component, const nkMaths::Rectangle& area) ;
			void addComponent (Component* component, const nkMaths::Rectangle& area, RELATIVE_POSITION position, Component* relativeTo) ;
			virtual void removeComponent (Component* component) override ;

			// Update
			virtual void update () override ;

			// Import / Export
			virtual void exportComponentsNodeEntry (nkExport::Node* rootNode) override ;
			virtual void processComponentsNodeEntry (nkExport::Node* rootNode) override ;

			// Operators
			RelativeLayout& operator= (const RelativeLayout&) = delete ;

		private :

			// Lifetime management
			std::vector<nkMemory::UniquePtr<RelativeLayoutEntryInfo>> _entries ;
			// As trees, keeping the roots
			std::vector<RelativeLayoutEntryInfo*> _roots ;
	} ;
}